--
--    Program : First.ada
--    Purpose : This program is a "first" Ada program, similar to C 
--              "Hello World" program.  It is intended to help the user
--              start using the GWUMON program by providing a program
--              which would be easy to get up and running.
--
--    Take the default options on the first screen (speed = 6, exceptions = yes,
--              and tasks = no) by hitting the "Esc" key.  Take the defaults on
--              the second screen (Small window, line tracing, and no procedure
--              tracing) by hitting the "Esc" key again.
--    Now the monitor should be running, stopped at the first executable 
--              statement, the elboration of name.  Hit the space key until
--              the program asks for your name.  Type in your name, then 
--              hit return.  Continue to hit the space key until the program
--              completes execution.
--
--    To use this program with GWUMON, from the DOS command line, type:
--                       adacomp -a -b -mfirst first.ada
--                       gwumon -mfirst
--
WITH Text_IO; USE Text_IO;

PROCEDURE First IS
  String_Size : CONSTANT Natural := 30;
  Name : String(1..String_Size) := (Others => ' ');
  Return_Size : Natural;
BEGIN
  Put_Line( "Please type in your name");
  Get_Line( Name, Return_Size );
  Put_Line( "Hello, " & Name );
END First;

